package parser;

import token.*;
import token.tokenizer.*;
import extvisitor.*;
import util.*;

/**
 * Factory for a simple non-terminal that references a single token.
 */
public class TerminalSymbolFact extends ATokVisitorFact {
  /**
   * Initializer lambda for this factory.
   */
  private ILambda<Object, Object> _initializer = new ILambda<Object, Object>() {
    public Object apply(Object... nu) {
      // change state to no-op
      _initializer = new NoOpLambda<Object>();
      
      // nothing to initialize
      return null;
    }
  };
  

  /**
   * Constructor for the Terminal Symbol factory.
   *
   * @param tkz tokenizer to use
   * @param name the name that references the single token
   */
  public TerminalSymbolFact(String name, ITokenizer tkz) {
    super(name, tkz);
  }
  
  
  private IExtVisitorCmd<IGrammarSymbol, String, Object, Token> thisCmd = new IExtVisitorCmd<IGrammarSymbol, String, Object, Token>() {
      public IGrammarSymbol apply(String idx, Token host, Object... inp) {
        System.out.println("TerminalSymbolFact("+_name+" = "+host+")");
        return new TerminalSymbol(_name,(Token)host);
      }
    };
  
  /**
   * Make a token visitor to parse a terminal.
   *
   * @return token visitor
   */
  public ATokVisitor<IGrammarSymbol, Object> makeVisitor() {
    initialize();
    
    return new ATokVisitor<IGrammarSymbol, Object>() {
      {
        setCmd(_name, thisCmd);
      }
    };
  }
  
  /**
   * Make a token visitor that will process the combination of this 
   * or the other given symbol 
   *
   * @param other The visitor for the other symbol in the combination 
   * @return A token visitor
   */
  public ATokVisitor<IGrammarSymbol, Object> makeCombinedVisitor(ATokVisitor<IGrammarSymbol, Object> other) {
    initialize();
    
    return new ATokVisitor<IGrammarSymbol, Object>(other) {
      {
        setCmd(_name, thisCmd);
      }
    };
  }
  
  /**
   * Make the visitor.
   */
  private void initialize() {
    _initializer.apply((Object) null);
    
  }
  
  public String toString() {
    return "TerminalSymbolFact("+_name+")";
  }
}

